CREATE TABLE Address (
  AddressID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  StreetID INTEGER UNSIGNED  NOT NULL  ,
  StreetNo VARCHAR(10)  NULL  ,
  CodeID INTEGER(10) UNSIGNED  NOT NULL  ,
  StateID CHAR(2)  NOT NULL    ,
PRIMARY KEY(AddressID));



CREATE TABLE Application (
  ApplicationID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  EmailID INTEGER UNSIGNED  NOT NULL  ,
  PositionID INTEGER(10) UNSIGNED  NOT NULL  ,
  LocationID INTEGER UNSIGNED  NOT NULL  ,
  DateAndTime DATETIME  NOT NULL    ,
PRIMARY KEY(ApplicationID));



CREATE TABLE Candidate (
  CandidateID INTEGER UNSIGNED  NOT NULL   AUTO_INCREMENT,
  Surname VARCHAR(45)  NOT NULL  ,
  Name VARCHAR(20)  NOT NULL    ,
PRIMARY KEY(CandidateID));



CREATE TABLE CandidateEmail (
  EmailID INTEGER UNSIGNED  NOT NULL   AUTO_INCREMENT,
  CandidateID INTEGER UNSIGNED  NOT NULL  ,
  Email VARCHAR(45)  NULL    ,
PRIMARY KEY(EmailID));



CREATE TABLE City (
  CityID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  CityName VARCHAR(45)  NOT NULL    ,
PRIMARY KEY(CityID));



CREATE TABLE Code (
  CodeID INTEGER(10) UNSIGNED  NOT NULL  ,
  CodeArea VARCHAR(45)  NOT NULL    ,
PRIMARY KEY(CodeID));



CREATE TABLE Contact (
  ContactID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  Surname VARCHAR(45)  NOT NULL  ,
  Name VARCHAR(20)  NOT NULL  ,
  AddressID INTEGER(10) UNSIGNED  NOT NULL  ,
  Telephone VARCHAR(20)  NOT NULL  ,
  Email VARCHAR(45)  NOT NULL    ,
PRIMARY KEY(ContactID));



CREATE TABLE Country (
  CountryID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  CountryName VARCHAR(45)  NOT NULL    ,
PRIMARY KEY(CountryID));



CREATE TABLE Location (
  LocationID INTEGER UNSIGNED  NOT NULL   AUTO_INCREMENT,
  CityID INTEGER(10) UNSIGNED  NOT NULL  ,
  CountryID INTEGER(10) UNSIGNED  NOT NULL    ,
PRIMARY KEY(LocationID));



CREATE TABLE Position (
  PositionID INTEGER(10) UNSIGNED  NOT NULL   AUTO_INCREMENT,
  ContactID INTEGER(10) UNSIGNED  NOT NULL  ,
  PositionCode VARCHAR(10)  NOT NULL  ,
  PositionDescription VARCHAR(255) BINARY  NOT NULL    ,
PRIMARY KEY(PositionID));



CREATE TABLE State (
  StateID CHAR(2)  NOT NULL  ,
  StateName VARCHAR(45)  NOT NULL    ,
PRIMARY KEY(StateID));



CREATE TABLE Street (
  StreetID INTEGER UNSIGNED  NOT NULL   AUTO_INCREMENT,
  StreetName VARCHAR(90)  NULL    ,
PRIMARY KEY(StreetID));




